﻿####################################################################
##

Write-Host "`n"
Write-Host "                    -------------------------------------------------            " -ForegroundColor Cyan
Write-Host "                    |                                               |            " -ForegroundColor Cyan
Write-Host "                    |                                               |            " -ForegroundColor Cyan
Write-Host "                    |          Application:                         |            " -ForegroundColor Cyan
Write-Host "                    |          Version: 1.0                         |            " -ForegroundColor Cyan
Write-Host "                    |                                               |            " -ForegroundColor Cyan
Write-Host "                    |          Author: Batman                       |            " -ForegroundColor Cyan
Write-Host "                    |          Date Created: 8/1/2025               |            " -ForegroundColor Cyan
Write-Host "                    |          Date Modified: 8/6/2025              |            " -ForegroundColor Cyan
Write-Host "                    |                                               |            " -ForegroundColor Cyan
Write-Host "                    -------------------------------------------------            " -ForegroundColor Cyan
Write-Host "`n"

####################################################################
# System setup information
#  Folder Structure
#  Connection Folder
#  Icons Folder
#  Images Folder
#  Lists Folder
#  Connection Script in root ofConnection Folder

# Audio text to speech
Add-Type -AssemblyName System.Speech
$Speech = New-Object System.Speech.Synthesis.SpeechSynthesizer
$Speech.SelectVoice("Microsoft Hazel Desktop")

# Vaiables
$timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
$username = ( ( Get-WMIObject -class Win32_ComputerSystem | Select-Object -ExpandProperty username ) -split '\\' )[1]
$SystemName = [Environment]::MachineName

# Read servers from file location
$serverFile = $PSScriptRoot + ".\Lists\servers.txt"
# Ensure the text file (links.txt) exists and contains one URL per line
$linksFile = $PSScriptRoot + ".\Lists\links.txt"

# Connection color status
$StatusGreen = $PSScriptRoot + ".\Images\green.jpg"
$StatusRed = $PSScriptRoot + ".\Images\red.jpg"

# Hello
$Speech.Speak("Hello $($Username) on $($SystemName)")

# Remote connection
#Set-Item WSMan:\localhost\Client\TrustedHosts -Value "*" -Concatenate
#Set-Item WSMan:\localhost\Service\AllowUnencrypted $true
#Set-Item WSMan:\localhost\Client\TrustedHosts *
#winrm quickconfig -transport:https
#netsh advfirewall firewall add rule name="WinRM HTTPS" dir=in action=allow protocol=TCP localport=5986

# Form
Add-Type -AssemblyName System.Windows.Forms
Add-Type -AssemblyName System.Drawing


# Function to collect system info
function Get-SystemInfo {
    $info = @()

    $info += "Current Computer Name: $Env:computername"
    #$info += "Current Logged On User: $([System.Security.Principal.WindowsIdentity]::GetCurrent().Name)"

    $info += "Current Logged On User: $Username"

    #$username = ( ( Get-WMIObject -class Win32_ComputerSystem | Select-Object -ExpandProperty username ) -split '\\' )[1]
    $ipAddress = [System.Net.Dns]::GetHostAddresses($selectedServer) | Where-Object { $_.AddressFamily -eq 'InterNetwork' } | Select-Object -First 1
    $info += "IP Address: $Ipaddress"     


    # CPU Info
    $cpu = Get-CimInstance -ClassName Win32_Processor | Select-Object -ExpandProperty Name
    $info += "CPU: $cpu"

    # Memory Info
    $memory = (Get-CimInstance -ClassName Win32_ComputerSystem).TotalPhysicalMemory / 1GB
    $info += "Installed RAM: {0:N2} GB" -f $memory

    # Storage Info
    $drives = Get-CimInstance Win32_LogicalDisk -Filter "DriveType=3"
    foreach ($drive in $drives) {
        $size = $drive.Size / 1GB
        $free = $drive.FreeSpace / 1GB
        $info += "Drive $($drive.DeviceID): Size = {0:N2} GB, Free = {1:N2} GB" -f $size, $free
    }

    return $info -join "`r`n"
}


# Create the form
$form = New-Object System.Windows.Forms.Form
$form.Text = "Batman's TECH Tool"
$form.Size = New-Object System.Drawing.Size(1480,900)
$form.StartPosition = "CenterScreen"
$form.BackColor = [System.Drawing.Color]::black


$imagePathmain = $PSScriptRoot + ".\images\batcomputer.jpg"  # Replace with your image file path
try {
    $backgroundImagemain = [System.Drawing.Image]::FromFile($imagePathmain)
    Write-Output "Image loaded successfully."
} catch {
    Write-Error "Failed to load image: $_"
}

#$backgroundImagemain = [System.Drawing.Image]::FromFile($imagePathmain)
$Form.BackgroundImage = $backgroundImagemain
$Form.BackgroundImageLayout = "Stretch"  # Options: None, Tile, Center, Stretch, Zoom

# Create the menu bar
$menuStrip = New-Object System.Windows.Forms.MenuStrip
$fileMenu = New-Object System.Windows.Forms.ToolStripMenuItem("File")
$filemenu.font = New-Object System.Drawing.Font("Lucida Console",10,[System.Drawing.FontStyle]::Regular)
$fileMenuAbout = New-Object System.Windows.Forms.ToolStripMenuItem("About")
$filemenuAbout.font = New-Object System.Drawing.Font("Lucida Console",10,[System.Drawing.FontStyle]::Regular)

# Exit Menu
$exitMenuItem = New-Object System.Windows.Forms.ToolStripMenuItem("Exit")

$exitMenuItem.Add_Click({$form.Close()
$Speech.Speak("Closing Bat Tech tool for $($Username) on $($SystemName)")
 }


)

$exitMenuItem.font = New-Object System.Drawing.Font("Lucida Console",10,[System.Drawing.FontStyle]::Regular)

# ABout Menu
$AboutMenuItem = New-Object System.Windows.Forms.ToolStripMenuItem("About")
#$AboutMenuItem.Add_Click({ $form.Close() })
$AboutMenuItem.font = New-Object System.Drawing.Font("Lucida Console",10,[System.Drawing.FontStyle]::Regular)

# Define About form popup
$aboutForm = New-Object System.Windows.Forms.Form
$aboutForm.Text = "About Batman's TECH Tool`r`n"
$aboutForm.Size = New-Object System.Drawing.Size(700,400)
$aboutForm.AutoSize = $true
$aboutForm.Location = New-Object System.Drawing.Point(100, 100)
$aboutForm.StartPosition = [System.Windows.Forms.FormStartPosition]::CenterScreen


# Set the form's icon
$iconPath = "D:\Scripts\PowerShell\RDPConnection\icons\batman.ico"  # Replace with your icon file path
$aboutForm.Icon = [System.Drawing.Icon]::ExtractAssociatedIcon($iconPath)




# Add a background image
$imagePath = "D:\Scripts\PowerShell\RDPConnection\images\batlogo.jpg"  # Replace with your image file path
$backgroundImage = [System.Drawing.Image]::FromFile($imagePath)
$aboutForm.BackgroundImage = $backgroundImage
$aboutForm.BackgroundImageLayout = "Stretch"  # Options: None, Tile, Center, Stretch, Zoom


# Add a label to About form
$label = New-Object System.Windows.Forms.Label
$label.Text = "This tool was built in 2025."
$label.Size = New-Object System.Drawing.Size(100, 100)
$label.AutoSize = $true
$label.font = New-Object System.Drawing.Font("Lucida Console",10,[System.Drawing.FontStyle]::bold) 
$Label.ForeColor = [System.Drawing.Color]::LIME
$label.BackColor = [System.Drawing.Color]::black
$label.Location = New-Object System.Drawing.Point(100, 10) 

# Create a LinkLabel
$linkLabel = New-Object System.Windows.Forms.LinkLabel
$linkLabel.Text = "website"
$linklabel.font = New-Object System.Drawing.Font("Lucida Console",12,[System.Drawing.FontStyle]::bold) 
$linklabel.BackColor = [System.Drawing.Color]::Transparent
$linkLabel.Size = New-Object System.Drawing.Size(165, 25)
$linkLabel.Location = New-Object System.Drawing.Point(250, 50)
$linkLabel.add_click({
    # Open the hyperlink in the default browser
    Start-Process "https://www.darkknighttech.com"
})



# When About is clicked, show the popup
$aboutMenuItem.Add_Click({
    $aboutForm.ShowDialog()
})


$fileMenu.DropDownItems.Add($exitMenuItem)
$fileMenuAbout.DropDownItems.Add($AboutMenuItem)
$menuStrip.Items.Add($fileMenu)
$menuStrip.Items.Add($fileMenuAbout)
$form.MainMenuStrip = $menuStrip


# Create a PictureBox to display the status image
$pictureBox = New-Object System.Windows.Forms.PictureBox
$pictureBox.Location = New-Object System.Drawing.Point(325, 40)
$pictureBox.Size = New-Object System.Drawing.Size(50, 50)


# Create the text box to display the selected link
$textBox = New-Object System.Windows.Forms.TextBox
$textBox.Multiline = $true
$textBox.ScrollBars = "Vertical"
$textBox.BorderStyle = [System.Windows.Forms.BorderStyle]::Fixed3D
$textBox.Location = New-Object System.Drawing.Point(740, 510)
$textBox.Size = New-Object System.Drawing.Size(700, 300)
$textBox.ReadOnly = $true
$textbox.ForeColor = [System.Drawing.Color]::LIME
$Textbox.BackColor = [System.Drawing.Color]::black
$textBox.font = New-Object System.Drawing.Font("Lucida Console",16,[System.Drawing.FontStyle]::Regular)

$textBox.Text = "[$timestamp]`r`n"
$textBox.AppendText($(Get-Systeminfo))

# Create the ComboBox
$comboBox = New-Object System.Windows.Forms.ComboBox
$comboBox.Location = New-Object System.Drawing.Point(10,50)
$comboBox.Size = New-Object System.Drawing.Size(200,20)
$comboBox.font = New-Object System.Drawing.Font("Lucida Console",14,[System.Drawing.FontStyle]::Regular)
$combobox.Cursor = [System.Windows.Forms.Cursors]::Hand

if (Test-Path $serverFile) {
    $servers = Get-Content $serverFile
    foreach ($server in $servers)
    
    {
        $combobox.Items.Addrange($server) 
    }
}



# Add server list to ComboBox
#$servers = @("1", "2", "3") # Replace with your server list
#$comboBox.Items.AddRange($servers)


# Create the combo box
$comboBoxLink = New-Object System.Windows.Forms.ComboBox
$comboBoxLink.Location = New-Object System.Drawing.Point(10, 100)
$comboBoxLink.Size = New-Object System.Drawing.Size(390, 20)
#$comboBoxLink.DropDownStyle = 2
#$combobox.FormattingEnabled = $True
#$comboBox.IntegralHeight = $False
#$ComboBoxLink.Height = 100
#$comboBoxLink.DropDownHeight = 140
$comboboxLink.Cursor = [System.Windows.Forms.Cursors]::Hand
$comboBoxLink.font = New-Object System.Drawing.Font("Lucida Console",14,[System.Drawing.FontStyle]::Regular)

# Populate the Link combo box from a text file
if (Test-Path $linksFile) {
    $comboBoxLink.Items.AddRange((Get-Content $linksFile))
} else {
    [System.Windows.Forms.MessageBox]::Show("File 'links.txt' not found!")
}


# Create the button
$button = New-Object System.Windows.Forms.Button
$button.Location = New-Object System.Drawing.Point(220,50)
$button.Size = New-Object System.Drawing.Size(100,30)
$button.Text = "Connect"
$Button.BackColor = [System.Drawing.Color]::lightgray

# Define the Connect button click event
$Button.Add_Click(
{
    $selectedServer = $comboBox.SelectedItem
   if ($selectedServer) 


   {
        $textBox.appendText("`r`nPinging $($selectedServer)...`r`n")
        $Speech.Speak("Pinging $($selectedServer)")
        # Ping the server
        $ping = Test-Connection -ComputerName $selectedServer -Count 1 -Quiet
        if ($ping) {
            $textBox.appendText("Ping successful.`r`n[$timestamp]`r`nConnecting to $($selectedServer) via RDP...`r`n")
            $Speech.Speak("Connecting to $($selectedServer)")
            $ipAddress = [System.Net.Dns]::GetHostAddresses($selectedServer) | Where-Object { $_.AddressFamily -eq 'InterNetwork' } | Select-Object -First 1
            

            $textBox.AppendText("Server: $($selectedServer)`r`nIP Address: $($ipAddress)`r`n")
            
            #$RCPU = Get-CimInstance -computername $SelectedServer -ClassName Win32_Processor | Select-Object -ExpandProperty Name

            #$textBox.AppendText("CPU: $RCPU`r`n")
            
            # Show green image
            $pictureBox.Image = [System.Drawing.Image]::FromFile("$StatusGreen")
            
            # Connect via RDP
            Start-Process "mstsc.exe" -ArgumentList "/v:$selectedServer"
            $Speech.Speak("Connection Successful to $($selectedServer)")
        } else {
            $textBox.AppendText("Ping failed. Unable to connect to $($selectedServer).")
            
            # Show red image
            $pictureBox.Image = [System.Drawing.Image]::FromFile("$StatusRed")
            $Speech.Speak("Connection failed to $($selectedServer)")
        }
    }


}  
)

# Create the button
$buttonrestart = New-Object System.Windows.Forms.Button
$buttonrestart.Location = New-Object System.Drawing.Point(410,50)
$buttonrestart.Size = New-Object System.Drawing.Size(100,30)
$buttonrestart.Text = "Restart"
$Buttonrestart.BackColor = [System.Drawing.Color]::lightgray

# Define the button click event
$Buttonrestart.Add_Click({
    $selectedServer = $comboBox.SelectedItem
    if ($null -ne $selectedServer) {
        $confirmation = [System.Windows.Forms.MessageBox]::Show("Are you sure you want to restart $selectedServer?", "Confirm Restart", [System.Windows.Forms.MessageBoxButtons]::YesNo, [System.Windows.Forms.MessageBoxIcon]::Warning)
        if ($confirmation -eq [System.Windows.Forms.DialogResult]::Yes) {
            try {
                Restart-Computer -ComputerName $selectedServer -Force -ErrorAction Stop
                [System.Windows.Forms.MessageBox]::Show("$selectedServer is restarting.", "Success", [System.Windows.Forms.MessageBoxButtons]::OK, [System.Windows.Forms.MessageBoxIcon]::Information)
                $pictureBox.Image = [System.Drawing.Image]::FromFile("$StatusGreen")
            } catch {
                [System.Windows.Forms.MessageBox]::Show("Failed to restart $selectedServer. Error: $_", "Error", [System.Windows.Forms.MessageBoxButtons]::OK, [System.Windows.Forms.MessageBoxIcon]::Error)
                $pictureBox.Image = [System.Drawing.Image]::FromFile("$StatusRed")
            }
        }
    } else {
        [System.Windows.Forms.MessageBox]::Show("Please select a server from the list.", "Warning", [System.Windows.Forms.MessageBoxButtons]::OK, [System.Windows.Forms.MessageBoxIcon]::Warning)
    }
})





# Define the Connect button click event
<#$Button.Add_Click(
{
    $selectedServer = $comboBox.SelectedItem
   if ($selectedServer) 


   {
        $textBox.appendText("`r`nPinging $($selectedServer)...`r`n")
        $Speech.Speak("Pinging $($selectedServer)")
        # Ping the server
        $ping = Test-Connection -ComputerName $selectedServer -Count 1 -Quiet
        if ($ping) {
            $textBox.appendText("Ping successful.`r`n[$timestamp]`r`nConnecting to $($selectedServer) via RDP...`r`n")
            $Speech.Speak("Restart $($selectedServer)")
            $ipAddress = [System.Net.Dns]::GetHostAddresses($selectedServer) | Where-Object { $_.AddressFamily -eq 'InterNetwork' } | Select-Object -First 1
            

            $textBox.AppendText("Server: $($selectedServer)`r`nIP Address: $($ipAddress)`r`n")
            
            #$RCPU = Get-CimInstance -computername $SelectedServer -ClassName Win32_Processor | Select-Object -ExpandProperty Name

            #$textBox.AppendText("CPU: $RCPU`r`n")
            
            # Show green image
            $pictureBox.Image = [System.Drawing.Image]::FromFile("$StatusGreen")
            
            # Connect via RDP
            #Start-Process "mstsc.exe" -ArgumentList "/v:$selectedServer"

            $Speech.Speak("Restart Successful to $($selectedServer)")
        } else {
            $textBox.AppendText("Restart failed. Unable to connect to $($selectedServer).")
            
            # Show red image
            $pictureBox.Image = [System.Drawing.Image]::FromFile("$StatusRed")
            $Speech.Speak("Restart failed to $($selectedServer)")
        }
    }


}  
)#>

# Create the button to open the link
$buttonLink = New-Object System.Windows.Forms.Button
$buttonLink.Text = "Open Link"
$buttonLink.Location = New-Object System.Drawing.Point(410, 100)
$buttonLink.Size = New-Object System.Drawing.Size(125, 30)
$buttonlink.BackColor = [System.Drawing.Color]::lightgray


# Button click event to open the selected link
$buttonLink.Add_Click({
    $selectedLink = $comboBoxLink.SelectedItem
    if ($selectedLink) {
        $textBox.AppendText("`r`nSelected Link: $($selectedLink)`r`n")
        $Speech.Speak("Connecting to $($selectedlink)")
        Start-Process $selectedLink
        $timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
        $textBox.AppendText("Current Time: $($timestamp)`r`nOpened URL: https://$($SelectedLink)`r`n")



    } else {
        [System.Windows.Forms.MessageBox]::Show("Please select a link from the combo box.")
    }
})


# Add controls to the form
$form.Controls.Add($menuStrip)
$form.Controls.Add($textBox)
$form.Controls.Add($pictureBox)
$form.Controls.Add($comboBox)
$form.Controls.Add($comboBoxLink)
$aboutForm.Controls.Add($label)
$Aboutform.Controls.Add($linkLabel)
$form.Controls.Add($button)
$form.Controls.Add($Buttonrestart)
$form.Controls.Add($buttonLink)

# Show the form
$form.Add_Shown({$form.Activate()})
[void]$form.ShowDialog()
